/*------------------------------------------------------------------------------*
 * File Name: ImpWizardPage.c													*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 01-11-2005 v8.0183 QA70-6555 NEW_IMPORT_MODES							*
 * SY 05/17/2005 QA70-7650 v8.0235 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG		*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "IWfirst.h"

//--------------------------------------------------------------------------
// ImpWizardPage
// 
//--------------------------------------------------------------------------
ImpWizardPage::ImpWizardPage()
{
	m_pSheet = NULL;
}

// must do this as the very first thing, before any other usage of this class
void ImpWizardPage::InitPage(int nID, ImpWizSheet* pSheet)
{
	m_pSheet = pSheet;
	SetID(nID);
}

BOOL ImpWizardPage::Init()
{
	//IW_Init(""); ///Danice 12/15/03 v7.5783 CHANGE_TO_SOURCEPAGE
	bool	bNeedInit = !bHasPageInit;
	bHasPageInit = true;
	return 	bNeedInit;
}

void ImpWizardPage::EnableFlag(DWORD dwFlag) 
{
	m_pSheet->EnableFlag(dwFlag);
}

void ImpWizardPage::DisableFlag(DWORD dwFlag) 
{
	m_pSheet->DisableFlag(dwFlag);
}

BOOL ImpWizardPage::IsFlagEnabled(DWORD dwFlag) 
{
	return m_pSheet->IsFlagEnabled(dwFlag);
}

BOOL ImpWizardPage::IsFlagDisabled(DWORD dwFlag)
{
	return m_pSheet->IsFlagDisabled(dwFlag);
}

void ImpWizardPage::SetComboBoxItems(ComboBox& cb, StringArray& sa)
{
	cb.ResetContent();
	for( int nItem = 0; nItem < sa.GetSize(); nItem++ )
		cb.AddString(sa[nItem]);
}

void ImpWizardPage::SetComboBoxItems(ComboBox& cb, LPCSTR lpcszItems, int nDelim)
{
	string strItems = lpcszItems;
	StringArray sa;
	strItems.GetTokens(sa, nDelim);
	SetComboBoxItems(cb, sa);
}

/// EJP 01-11-2005 v8.0183 QA70-6555 NEW_IMPORT_MODES
int ImpWizardPage::GetListIndexFromImportMode(int nImportMode)
{
	/// SY 05/17/2005 QA70-7650 v8.0235 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
	///	/* following defines copied from OC_Types.h
	///	#define ASCIMP_MODE_REPLACE_DATA		0
	///	#define ASCIMP_MODE_APPEND_COLS			1
	///	#define ASCIMP_MODE_APPEND_ROWS			2
	///	#define ASCIMP_MODE_NEW_BOOKS			3
	///	#define ASCIMP_MODE_NEW_SHEETS			4
	///	#define ASCIMP_MODE_AUTO				5
	///	*/
	///	static int s_nListIndex[] = {
	///		IW_LIST_IMPMODE_REPLACE,
	///		IW_LIST_IMPMODE_NEW_COLS,
	///		IW_LIST_IMPMODE_NEW_ROWS,
	///		IW_LIST_IMPMODE_NEW_BOOKS,
	///		IW_LIST_IMPMODE_NEW_SHEETS,
	///		IW_LIST_IMPMODE_AUTO
	///	};
	///	if( IS_IMPORT_MODE(nImportMode) )
	///		return s_nListIndex[nImportMode];
	///	return IW_LIST_IMPMODE_AUTO;
	return _GetListIndexFromImportMode(nImportMode);
	/// end MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
}

int ImpWizardPage::GetImportModeFromListIndex(int nListIndex)
{
	/// SY 05/17/2005 QA70-7650 v8.0235 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
	///	/* following enum copied from ImpWizardPage.h
	///	IW_LIST_IMPMODE_AUTO = 0,
	///	IW_LIST_IMPMODE_REPLACE,
	///	IW_LIST_IMPMODE_NEW_BOOKS,
	///	IW_LIST_IMPMODE_NEW_SHEETS,
	///	IW_LIST_IMPMODE_NEW_COLS,
	///	IW_LIST_IMPMODE_NEW_ROWS
	///	*/
	///	static int s_nImportMode[] = {
	///		ASCIMP_MODE_AUTO,
	///		ASCIMP_MODE_REPLACE_DATA,
	///		ASCIMP_MODE_NEW_BOOKS,
	///		ASCIMP_MODE_NEW_SHEETS,
	///		ASCIMP_MODE_APPEND_COLS,
	///		ASCIMP_MODE_APPEND_ROWS
	///	};
	///	if( 0 <= nListIndex && nListIndex < (sizeof(s_nImportMode) / sizeof(int)) )
	///		return s_nImportMode[nListIndex];
	///	return ASCIMP_MODE_AUTO;
	return _GetImportModeFromListIndex(nListIndex);
	/// end MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
}
/// end NEW_IMPORT_MODES

BOOL ImpWizardPage::GetRichEditSelection(RichEdit& re, int& nFirstLine, int& nLastLine, int& nFirstLineChar, int& nLastLineChar)
{
	long nStartChar, nEndChar;
	re.GetSel(nStartChar, nEndChar);
	if( nStartChar == nEndChar )
		return FALSE; // no selection
	
	// Adjust nEndChar so it equals the last selected char
	// instead of the char after the last selected char.
	nEndChar--;

	nFirstLine = re.LineFromChar(nStartChar);
	nLastLine = re.LineFromChar(nEndChar);

	int nLineChar;
	nLineChar = re.LineIndex(nFirstLine);
	nFirstLineChar = nStartChar - nLineChar;
	nLineChar = re.LineIndex(nLastLine);
	nLastLineChar = nEndChar - nLineChar;
	
	return TRUE;
}

//--------------------------------------------------------------------------
// ImpWizAscPage
// 
//--------------------------------------------------------------------------
bool ImpWizAscPage::GetHeaderLines(StringArray& saHdrLines)
{
	saHdrLines.RemoveAll();
	///if( ReadFileLines(saHdrLines, IW_DATAFILE, ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR)) )
	if( !fuGetHdrLines(IW_FILTER, saHdrLines, IW_DATAFILE) )
	{
		DataFileErrorMsgBox();
		return false;
	}
	return true;
}

bool ImpWizAscPage::GetHeaderLines(string& strLines)
{
	if( LoadTextFile(strLines, IW_DATAFILE, ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR)) )
	{
		DataFileErrorMsgBox();
		return false;
	}
	return true;
}

void ImpWizAscPage::InsertLineNumbers(StringArray& sa)
{
	string str;
	for( int nIndex = 0; nIndex < sa.GetSize(); nIndex++ )
	{
		str.Format("H%03d  ", nIndex + 1);
		sa[nIndex].Insert(0, str);
	}
}

bool ImpWizAscPage::SetRichEdit(RichEdit& re, StringArray& sa)
{
	if( re )
	{
		StringArray saTmp;
		saTmp = sa;
		InsertLineNumbers(saTmp);
		re.Text.Empty();
		re.Text.SetTokens(saTmp, '\n');
	}
	return false;
}

void ImpWizAscPage::InitRichEditWithHeaderLines(RichEdit& re)
{
	if( re )
	{
		re.Text.Empty();
		re.SetFont(IW_PREVIEW_FONT);
		string str;
		if( GetHeaderLines(str) )
		{
			re.Text = str;
			re.SetSel(0, 0);
		}
	}
}

int ImpWizAscPage::DataFileErrorMsgBox()
{
	string strText;
	strText.Format("Error opening/reading data file:\n%s", GetFileName(IW_DATAFILE));
	return MessageBox(GetSafeHwnd(), strText, "Import Wizard");
}
